package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.powers.ForceField;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ForceFieldDialog extends PowerDialog {

	private static final long serialVersionUID = 8808441129185534205L;

	JLabel pdLbl;

	LevelTF pdLevelTF;

	JLabel edLbl;

	LevelTF edLevelTF;

	JLabel mdLbl;

	LevelTF mdLevelTF;

	JLabel powdLbl;

	LevelTF powdLevelTF;

	public ForceFieldDialog(ForceField pow, boolean isNew, boolean isPower) {
		super(pow, isNew, isPower);
		power = pow;
		init();
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.gridy = 70;
		panel.add(pdLbl, gbc);
		gbc.gridy++;
		panel.add(edLbl, gbc);
		gbc.gridy++;
		panel.add(mdLbl, gbc);
		gbc.gridy++;
		panel.add(powdLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(powdLevelTF, gbc);
		gbc.gridy--;
		panel.add(mdLevelTF, gbc);
		gbc.gridy--;
		panel.add(edLevelTF, gbc);
		gbc.gridy--;
		panel.add(pdLevelTF, gbc);
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		pdLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((ForceField) power)
								.setPdLevels(pdLevelTF.getCurrent());
						updateValues();
					}
				});
		edLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((ForceField) power)
								.setEdLevels(edLevelTF.getCurrent());
						updateValues();
					}
				});
		mdLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((ForceField) power)
								.setMdLevels(mdLevelTF.getCurrent());
						updateValues();
					}
				});
		powdLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((ForceField) power).setPowdLevels(powdLevelTF
								.getCurrent());
						updateValues();
					}
				});

	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		levelTF.setVisible(false);
		damageLbl.setVisible(false);
		levelsLbl.setVisible(false);
		pdLbl = new JLabel("PD:");
		edLbl = new JLabel("ED:");
		mdLbl = new JLabel("Mental Def.:");
		powdLbl = new JLabel("Power Def.:");
		pdLevelTF = new LevelTF(((ForceField) power).getPdLevels(), 999, 0);
		edLevelTF = new LevelTF(((ForceField) power).getEdLevels(), 999, 0);
		mdLevelTF = new LevelTF(((ForceField) power).getMdLevels(), 999, 0);
		powdLevelTF = new LevelTF(((ForceField) power).getPowdLevels(), 999, 0);
	}

	@Override
	public void updateValues() {
		super.updateValues();
	}
}